%SiMing's bacteria tracking code
%The code contains a total of 5 cases. Case 1 sorts objects indentified in
%cell_loc into paths. Case 2 marks the viablibity of each path. The options
%being viable(1), unviable(2), stuck(3). Case 3 creates a histogram of
%where the paths landed in the x-position. Case 4 calculates the TMC. Case
%5 plots all the viable paths visually.

switch 1
    case 1
%Cells are organized by paths using nearest-neighbour approach 

clear all; close all;
%insert location of cell_loc file to be analyzed:
cell_loc = load('/Users/SiMing/Desktop/Ryu Lab/cell_loc_array_results/0.1_ser_2326_jan17  cell_loc.mat');
cell_loc = cell_loc.cell_loc;
frames = size(cell_loc,1);
path_c = 1;
max_d = 60;
new_path = 0;

for count_pic = 1:frames

[cell_loc path_c] = label_objects(cell_loc, count_pic, path_c, max_d, new_path);

end

%adds sixth column for frame number of each object
for frame_n = 1:frames
    cell_loc{frame_n}(:,6) = frame_n;
end

%sort the objects by paths
arranged_paths = cell(path_c, 1);

for each_frame = 1:frame_n,
    for each_line = 1:numel(cell_loc{each_frame, 1}(:,1)),
        object_number = cell_loc{each_frame, 1}(each_line, 5);
        this_frame = cell_loc{each_frame, 1}(each_line, 6);
        if ~isnan(cell_loc{each_frame, 1}(1,1)),   
            arranged_paths{object_number, 1}(end+1,:) = cell_loc{each_frame, 1}(each_line,:);
        end
    end
end

arranged_paths = arranged_paths(~cellfun(@isempty, arranged_paths)); %removes empty cells

% arranged_paths:
% 1: x-position
% 2: y-position
% 3:eccentricity
% 4:area
% 5:path number
% 6:frame number

%--------------------------------------------------------------------------

%This case is where the paths are marked viable or not

    case 2
%calculates standard deviation for each path in the x,y-direction
standard_devation_x = zeros(length(arranged_paths), 1);
standard_devation_y = zeros(length(arranged_paths), 1);

for each_object = 1:object_number,
    std_x = std(arranged_paths{each_object,1}(:,1));
    standard_devation_x(each_object) = std_x;
    std_y = std(arranged_paths{each_object,1}(:,2));
    standard_devation_y(each_object) = std_y;
end

%std_y/std_x
stdy_over_stdx = standard_devation_y ./ standard_devation_x;

%finds length of path
length_of_each_path = zeros(length(arranged_paths), 1);

for each_path = 1:length(arranged_paths),
    whatislength = length(arranged_paths{each_path, 1}(:,1));
    length_of_each_path(each_path) = whatislength;
end

%std_y/pathlength
stdy_over_pathlength = standard_devation_y ./ length_of_each_path;

arranged_paths{1,2} = []; %creates column for std_x of path
arranged_paths{1,3} = []; %creates column for std_y of path
arranged_paths{1,4} = []; %creates column for std_y/std_x of path
arranged_paths{1,5} = []; %creates column for length of path
arranged_paths{1,6} = []; %creates column for viability marking
arranged_paths{1,7} = []; %creates column for std(y)/pathlength


for each_path = 1:length(arranged_paths),
    arranged_paths{each_path, 2} = standard_devation_x(each_path);
end

 
for each_path = 1:length(arranged_paths),
    arranged_paths{each_path, 3} = standard_devation_y(each_path);
end

for each_path = 1:length(arranged_paths),
    arranged_paths{each_path, 4} = stdy_over_stdx(each_path);
end

for each_path = 1:length(arranged_paths),
    arranged_paths{each_path, 5} = length_of_each_path(each_path);
end

for each_path = 1:length(arranged_paths),
    arranged_paths{each_path, 7} = stdy_over_pathlength(each_path);
end

%Criteria for viability. Can be adjusted depending on data.
max_stdy_over_stdy = 18;
min_pathlength = 10;
max_sty_over_pathlength_stuck = 0.25;
max_stdx_stuck = 3;

for each_path = 1:length(arranged_paths),
    if (arranged_paths{each_path,4} < max_stdy_over_stdy) & (arranged_paths{each_path,5} >= min_pathlength),
        arranged_paths{each_path,6} = 1;
    else (arranged_paths{each_path,4} >= max_stdy_over_stdy);
        arranged_paths{each_path,6} = 0;
    end
end

%criteria for stuck cell
for each_path = 1:length(arranged_paths),
    if ~isnan(arranged_paths{each_path, 4}); 
        if (arranged_paths{each_path, 7} < max_sty_over_pathlength_stuck) & (arranged_paths{each_path, 2} <max_stdx_stuck),
            arranged_paths{each_path,6} = 3;
        end
    end
end
  
%array with only viable paths
paths = cell(length(arranged_paths), 2);

for each_path = 1:length(arranged_paths),
    paths{each_path,2} = arranged_paths{each_path, 6};
    paths{each_path, 1} = arranged_paths{each_path, 1};
end

viable_paths = cell(object_number, 1);

for each_path = 1:object_number,
    if arranged_paths{each_path, 6} == 1,
        viable_paths{each_path,1} = arranged_paths{each_path, 1};
    end
end

viable_paths = viable_paths(~cellfun('isempty', viable_paths));  
%--------------------------------------------------------------------------
    case 3 
%creates histogram

set(0,'defaultaxesfontsize',14);
set(0,'defaulttextfontsize',14);
working_directory = '';
num_x_values = 0;

for each_viable_path = 1:length(viable_paths),
    length_x = length(viable_paths{each_viable_path, 1}(:,1));
    num_x_values = num_x_values + length_x;
end

all_x_values = zeros(num_x_values, 1);
all_x_values(1) = 1;
all_x_values(1:(length(viable_paths{1,1}(:,1)))) = viable_paths{1,1}(:,1);

for each_viable_path = 2:length(viable_paths),
    index = find(all_x_values);
    index = index(end);
    all_x_values((index+1):(index+length(viable_paths{each_viable_path,1}(:,1)))) = viable_paths{each_viable_path,1}(:,1);
end

%x value cutoff
x_cutoff_right = 1280; %can changed depending on where you start counting from x-direction
x_cutoff_left = 180;
y_depth = 960;

all_x_values(all_x_values < x_cutoff_left) = [];
all_x_values(all_x_values > x_cutoff_right) = [];

numbins = 10;
binsize =  (x_cutoff_right-x_cutoff_left)/numbins;
sort_new = sort(all_x_values);
[x_values_normalized x_val] = hist(sort_new,numbins);
x_values_normalized = x_values_normalized/size(all_x_values,1);
num_viable_paths = length(viable_paths);

figure, bar(x_val, x_values_normalized); figure(gcf)
xlabel(strcat('X-Position (',num2str(binsize),'Pixels/Bin)'));
ylabel(strcat('Count (Viable paths N = ',num2str(num_viable_paths),', Data pts N = ', num2str(length(all_x_values)),')'));
title({'Histogram of detected X-Positions for Viable Bacteria'; strcat(working_directory, ' for 0<Y<=', num2str(y_depth)) ; strcat(num2str(x_cutoff_right),'<=X<=',num2str(x_cutoff_left))}, 'interpreter', 'none');

%-------------------------------------------------------------------------

%Calculates the TMC
    case 4     
        tmc(all_x_values, x_cutoff_left, x_cutoff_right)

%-------------------------------------------------------------------------
 %Plots all viable paths
    case 5

        for path_number = 1:length(viable_paths),
            CM = jet(length(viable_paths));
            plot(path{path_number}(:,1), path{path_number}(:,2), 'color', CM(path_number, :));
            axis([0 1280 0 960]);
            hold on

        end
end
